import time, board, adafruit_dht

dhtDevice = adafruit_dht.DHT11(board.D17)

try:
    while True:
        try:
            temperature_c = dhtDevice.temperature
            humidity = dhtDevice.humidity
            print("Temp: {:.1f}°C Humidity: {}%".format(temperature_c, humidity))
            time.sleep(2.0)
        except RuntimeError as error:
            print(error.args[0])
            time.sleep(2.0)
            continue
        
except KeyboardInterrupt as error:
    print("CTRL-C pressed. Deiniting everything...")
    dhtDevice.exit()
