import time, board
import adafruit_dht
import numpy as np
import matplotlib.pyplot as plt

# Initialisierung des DHT22 Sensors
sensor = adafruit_dht.DHT11(board.D17)  # D4 ist der GPIO-Pin

# Listen für die Daten
temperature_readings = []
window_size = 5  # Fenstergröße für die Mittelung
smoothed_readings = []

try:
    # 50 Messungen durchführen
    
    for i in range(50):
        try:
            # Temperaturdaten auslesen
            temp_c = sensor.temperature
            temperature_readings.append(temp_c)
            
            # Berechne den gleitenden Durchschnitt, wenn genug Daten vorhanden sind
            if len(temperature_readings) >= window_size:
                window = temperature_readings[-window_size:]
                average = np.mean(window)
                smoothed_readings.append(average)
            else:
                smoothed_readings.append(np.nan)  # Nicht genug Daten für Mittelung

            print(f"{temp_c:.2f}°C, Geglättet: {smoothed_readings[-1]:.2f}°C")
        
            time.sleep(2)  # 2 Sekunden warten zwischen den Messungen
        
        except RuntimeError as error:
            # Fehler beim Lesen ignorieren
            print(f"Lesefehler: {error}")
    
    time.sleep(2)  # 2 Sekunden warten zwischen den Messungen
    
    # Plot der Rohdaten und geglätteten Daten
    plt.figure(figsize=(10, 5))
    plt.plot(temperature_readings, 'k.-', label='Rohdaten')
    plt.plot(smoothed_readings, 'r.-', label='Gleitender Durchschnitt')
    plt.xlabel('Messung')
    plt.ylabel('Temperatur (°C)')
    plt.title('Temperaturmessung mit gleitendem Durchschnitt')
    plt.legend()
    plt.grid(linestyle=':')
    plt.show()

except KeyboardInterrupt as error:
    print("CTRL-C pressed. Deiniting everything...")
    sensor.exit()