import os
import glob
import time

# Sensorverzeichnis finden
base_dir = "/sys/bus/w1/devices/"
device_folder = glob.glob(base_dir + "10*")[0]
device_file = device_folder + "/w1_slave"

def read_temp_raw():
    with open(device_file, "r") as f:
        return f.readlines()

def read_temp():
    lines = read_temp_raw()
    while lines[0].strip()[-3:] != "YES":
        time.sleep(0.2)
        lines = read_temp_raw()
    temp_output = lines[1].split("t=")
    if len(temp_output) > 1:
        temp_c = float(temp_output[1]) / 1000.0
        return temp_c

while True:
    print("Temperatur: {:.2f}°C".format(read_temp()))
    time.sleep(1)