import numpy as np
import matplotlib.pyplot as plt
from scipy.signal import butter, lfilter

# Hochpassfilter-Definition
def butter_highpass(cutoff, fs, order=5):
    nyquist = 0.5 * fs  # Nyquist-Frequenz
    normal_cutoff = cutoff / nyquist
    b, a = butter(order, normal_cutoff, btype='high', analog=False)
    return b, a

def highpass_filter(data, cutoff, fs, order=5):
    b, a = butter_highpass(cutoff, fs, order=order)
    y = lfilter(b, a, data)
    return y

# Filtereinstellungen
fs = 100.0  # Abtastrate (Hz)
cutoff = 10.0  # Grenzfrequenz (50 Hz)
order = 2  # Filterordnung

# Simuliere Optosensordaten mit Störungen im niedrigen Frequenzbereich
t = np.linspace(0, 5, int(fs * 5))  # Zeitachse für 5 Sekunden
low_freq_noise = np.sin(2 * np.pi * 5 * t)  # Niederfrequentes Rauschen (5 Hz)
high_freq_signal = np.sin(2 * np.pi * 100 * t)  # Hochfrequentes Signal (100 Hz)
sensor_data = low_freq_noise + high_freq_signal  # Signal + niederfrequentes Rauschen

# Hochpassfilter anwenden
filtered_data = highpass_filter(sensor_data, cutoff, fs, order)

# Daten visualisieren
plt.figure(figsize=(12, 6))
plt.plot(t, sensor_data, label='Rohdaten (mit niederfrequentem Rauschen)', color='red', alpha=0.6)
plt.plot(t, 3*filtered_data, label='Gefilterte Daten (Hochpass 50 Hz)', color='blue', linewidth=2)
plt.xlabel('Zeit (s)')
plt.ylabel('Signalwert')
plt.title('50-Hz-Hochpassfilter für Sensor-Daten')
plt.legend()
plt.grid(True)
plt.show()
