import numpy as np
import matplotlib.pyplot as plt

N=100

# Erstelle die x-Werte
x = np.linspace(0, 10, N)

# Ersetze die Sinuswerte durch Zufallszahlen
y = np.sin(x)+0.5*np.random.rand(N)  # 50 Zufallszahlen zwischen 0 und 1

# Definiere die Fenstergröße für den gleitenden Durchschnitt
window = 9

# Berechne den gleitenden Durchschnitt
average_y = []
for ind in range(len(y) - window + 1):
    average_y.append(np.mean(y[ind:ind+window]))

# Ergänze die NaN-Werte am Anfang, damit die Längen übereinstimmen
for ind in range(window - 1):
    average_y.insert(0, np.nan)

# Plotten der Daten
plt.figure(figsize=(10, 5))
plt.plot(x, y, 'y.-', label='Originaldaten')
plt.plot(x, average_y, 'r.-', label='Running average')
plt.grid(linestyle=':')
plt.legend()
plt.show()
