import numpy as np
import matplotlib.pyplot as plt

# 1. Simuliertes Sensorsignal (Sinuswelle + Rauschen)
np.random.seed(0)  # Für reproduzierbare Ergebnisse
time = np.linspace(0, 1, 500)  # 1 Sekunde mit 500 Messpunkten
signal = 2 * np.sin(2 * np.pi * 5 * time)  # Reines Sinussignal mit 5 Hz
noise = 0.5 * np.random.randn(500)  # Zufälliges Rauschen
raw_signal = signal + noise

# 2. Offset zum ursprünglichen Signal hinzufügen
offset = 3.0  # Konstanter Offset
offset_signal = raw_signal + offset

# 3. Tiefpassfilterung (gleitender Mittelwert)
window_size = 30
filtered_signal = np.convolve(offset_signal, np.ones(window_size)/window_size, mode='valid')

# 4. Normalisierung des Signals (Skalierung zwischen 0 und 1)
normalized_signal = (filtered_signal - np.min(filtered_signal)) / (np.max(filtered_signal) - np.min(filtered_signal))

# 5. Zentrierung auf die Nulllinie (Mittelwert abziehen)
centered_signal = normalized_signal - np.mean(normalized_signal)

# 7. Weitere Verstärkung des konditionierten Signals (20-fach)
final_gain = 20.0
processed_signal = centered_signal * final_gain

# 8. Visualisierung
plt.figure(figsize=(12, 6))
# plt.plot(time, raw_signal, label="Rohsignal mit Rauschen", alpha=0.5)
plt.plot(time, offset_signal, color='red', alpha=0.7)
plt.plot(time[:len(processed_signal)], processed_signal, color='blue', linewidth=2)
plt.xlabel('Zeit (s)')
plt.ylabel('Signalstärke')
plt.title('Signalkonditionierung: Offset, Zentrierung, Verstärkung und Normalisierung')
plt.legend()
plt.grid(True)
plt.show()
